package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general;

import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Obtention des informations de la librairie
 *
 */
public class InfoLibrairie{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(InfoLibrairie.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
			
				ResultatInfo resultat = new ResultatInfo("Obtenir des informations sur la librairie (C_GetInfo)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
				
					// Traitement  tester
					CK_INFO info = librairie.C_GetInfo();
	
					if(info != null) {
					
						// Formatage du rsultat
						infos.put("Version de la librairie",info.libraryVersion.toString());
						infos.put("Identifiant de la bibliothque du fabricant",new String(info.manufacturerID));
						infos.put("Description de la librairie",new String(info.libraryDescription));
						infos.put("Version de limplmentation de la librairie",info.cryptokiVersion.toString());
						
					} else {
						
						// Si les informations sont nulles on lve l'exception
						log.error("L'operation a retourne des informations nulles");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_INFO_LIB, "L'opration a retourn des informations nulles");
						
					}
		
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}		
					
				return resultat;
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_INFO_LIB, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_GENERAL_INFO_LIB, "Une erreur inattendue est survenue");
			
		}
			
	}

}
